function CDX = import_cds_barcap(filename)
% --------------------------------------------------------------------------------------------------
% Import historical CDS data provided by BarCap
% --------------------------------------------------------------------------------------------------
% sample call: import_cds_barcap('c:/thesis/data/barcap/HistoricalSpreads.xls')
% --------------------------------------------------------------------------------------------------

% Define empty CDX structure
CDX = struct( ...
    'dates', {{[] [] []}}, 'T', {{[] [] []}}, 'cut_offs', {[0.03 0.07 0.1 0.15 0.3]}, ...
    'index_market_price', {{[] [] []}}, ...
    'tranche_market_price_mid', {{[] [] []}}, ...
    'tranche_market_upfront_mid', {{[] [] []}}, ...
    'portfolio', [], ...
    'index_members', {repmat(NaN, length(10), 0)} ...
);
ajd_dynamics = struct('k', 0.2, 'theta', 0.02, 'sigma', 0.01, 'L', 0.2, 'mu', 0.03);

% Import data
[num, txt] = xlsread(filename, 1);
tickers = {txt{1,2:end}}';
codes = num(1,:)';
dates = datenum({txt{2:end,1}}');
cds_spreads = num(3:end,:);

% Insert data into CDX structure
for i=1:length(tickers)
    % Insert prices into CDS
    cds = struct( ...
                  'company', '', 'ticker', tickers{i}, 'code', codes(i), 'dates', {{[] [] [] []}}, ...
                  'market_price', {{[] [] [] []}}, 'x0', [], 'AJD', ajd_dynamics, 'LGD', 0.6, 'ai', 1, 'bi');
    cds_5yr = cds_spreads(:,i);  
    available = ~isnan(cds_5yr);
    cds.dates{1} = dates(available);
    cds.market_price{1} = cds_spreads(available, i);
              
    % Insert CDS into CDX          
    if (isempty(CDX.portfolio))
        CDX.portfolio = [cds];
    else
        CDX.portfolio(i) = cds;
    end
end